import java.util.Objects;

// Weil Mint das Interface Comparable<Mint> implementiert,
// kann eine Liste mit Mint-Elementen bequem sortiert werden.
public class Mint implements Comparable<Mint> {
    public int value;

    public Mint(int value) { 
        this.value = value;
    } 

    public Mint() {}

	// Die Marker-Annotation @Override signalisiert das Überschreiben einer Basisklassenmethode
	@Override
    public String toString() {
    	return String.valueOf(value);
    }

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Mint mi) {
			return value == mi.value;
		} else
    		return false;
    }

	@Override
	public int hashCode() {
		return Objects.hash(value);
	}

	// Das Interface Comparable<Mint> verlangt die Methode compareTo().
	// Die statische Integer-Methode compareTo() verarbeitet int-Parameter.
	// Es ist also  k e i n  Boxing erforderlich.
	public int compareTo(Mint other) {
		return Integer.compare(this.value, other.value);
	}
}
